const NOBLOCK      = LoadImage("NoBlock.png");
const GREYBLOCK    = LoadImage("GreyBlock.png");
const REDBLOCK     = LoadImage("RedBlock.png");
const PURPLEBLOCK  = LoadImage("PurpleBlock.png");
const BLUEBLOCK    = LoadImage("BlueBlock.png");
const YELLOWBLOCK  = LoadImage("YellowBlock.png");
const GREENBLOCK   = LoadImage("GreenBlock.png");
const ORANGEBLOCK  = LoadImage("OrangeBlock.png");
const CYANBLOCK    = LoadImage("CyanBlock.png");
const WHITEBLOCK   = LoadImage("WhiteBlock.png");

const L = new Piece(0,0,[[NOBLOCK, ORANGEBLOCK],[NOBLOCK, ORANGEBLOCK],[ORANGEBLOCK, ORANGEBLOCK]]);
const J = new Piece(0,0,[[BLUEBLOCK,BLUEBLOCK],[NOBLOCK,BLUEBLOCK],[NOBLOCK,BLUEBLOCK]]);
const Z = new Piece(0,0,[[REDBLOCK,NOBLOCK],[REDBLOCK,REDBLOCK],[NOBLOCK,REDBLOCK]]);
const S = new Piece(0,0,[[NOBLOCK,GREENBLOCK],[GREENBLOCK,GREENBLOCK],[GREENBLOCK,NOBLOCK]]);
const T = new Piece(0,0,[[PURPLEBLOCK,NOBLOCK],[PURPLEBLOCK,PURPLEBLOCK],[PURPLEBLOCK,NOBLOCK]]);
const O = new Piece(0,0,[[YELLOWBLOCK,YELLOWBLOCK],[YELLOWBLOCK,YELLOWBLOCK]]);
const I = new Piece(0,0,[[CYANBLOCK],[CYANBLOCK],[CYANBLOCK],[CYANBLOCK]]);

/*
 * x = x of piece in 2DArray, situated at top right.
 * y = y of piece in 2DArray, situated at top right.
 * rep = the 2DArray number representation of the piece.
 * image = the block image to use for each of the piece's blocks.
 */
function Piece(x, y, rep)
{
	this.x = x;
	this.y = y;
	this.rep = rep;
	this.leftTime = 0;
	this.leftPressed = false;
	this.rightTime = 0;
	this.rightPressed = false;
	this.downTime = 0;
	this.rotateButtonPressed = false;
}

Piece.prototype.clone = function()
{
	var newPiece = new Object();
	for(var i in this)
		newPiece[i] = this[i];
	return newPiece;
}

Piece.prototype.rotate = function(board) {
	this.rotateRight(board);
	this.fixObstructions(board);
}

Piece.prototype.resetLeftTimes = function() {
	this.leftTime = 0;
	this.leftPressed = false;
}

Piece.prototype.resetRightTimes = function() {
	this.rightTime = 0;
	this.rightPressed = false;
}

Piece.prototype.moveLeft = function(board) {
	if(this.leftTime < GetTime()) {
		if(this.leftPressed) {
			this.leftTime = GetTime() + 25;
		} else {
			this.leftTime = GetTime() + 125;
		}
		this.leftPressed = true;
		this.x--;
		var bool = true;
		if(this.fixObstructions(board)) {
			bool = false;
		}
		if(this.isObstructing(board)) {
			this.x++;
			bool = false;
		}
		return bool;
	}
}

Piece.prototype.moveRight = function(board) {
	if(this.rightTime < GetTime()) {
		if(this.rightPressed) {
			this.rightTime = GetTime() + 25;
		} else {
			this.rightTime = GetTime() + 125;
		}
		this.rightPressed = true;
		this.x++;
		var bool = true;
		if(this.fixObstructions(board)) {
			bool = false;
		}
		if(this.isObstructing(board)) {
			this.x--;
			bool = false;
		}
		return bool;
	}
}

Piece.prototype.moveDown = function(board) {
	if(this.downTime < GetTime()) {
		this.downTime = GetTime() + 75;
		this.y++;
		if(this.isObstructing(board)) {
			this.y--;
		}
	}
}

Piece.prototype.fixObstructions = function(board)
{
	if(this.x + this.rep.length > board.length) {
		this.x = board.length - this.rep.length;
		return true;
	} else if(this.x < 0) {
		this.x = 0;
		return true;
	}
	return false;
}

/*
 * Be sure that the brickMap is BIGGER or equal to in size as the piece.
 */
Piece.prototype.isObstructing = function(brickMap)
{
	for(var y=0;y<this.rep[0].length;y++)
	{
		for(var x=0;x<this.rep.length;x++)
		{
			if(this.y + y >= 0)
				if(this.rep[x][y] != NOBLOCK && brickMap[this.x + x][this.y + y] != NOBLOCK)
					return true;
		}
	}
	return false;
}

Piece.prototype.rotateRight = function(board)
{
	var newPiece = this.clone();
	newPiece.rep = new Array(this.rep[0].length);
	var xLength = newPiece.rep.length;
	for(var i=0;i<xLength;i++)
		newPiece.rep[i] = new Array(this.rep.length);
	for(var y=0;y<newPiece.rep[0].length;y++)
	{
		for(var x=0;x<xLength;x++)
		{
			newPiece.rep[x][y] = this.rep[y][xLength - x - 1];
		}
	}
	newPiece.x += this.rep.length - newPiece.rep.length;
	newPiece.fixObstructions(board);
	if(!newPiece.isObstructing(board) && !this.equals(newPiece)) {
		this.rep = newPiece.rep;
		this.x = newPiece.x;
		this.fixObstructions(board);
		return true;
	}
	return false;
}

Piece.prototype.rotateLeft = function(board) {
	var newPiece = this.clone();
	newPiece.rep = new Array(this.rep[0].length);
	var xLength = newPiece.rep.length;
	for(var i=0;i<xLength;i++)
		newPiece.rep[i] = new Array(this.rep.length);
	var yLength = newPiece.rep[0].length;
	for(var y = 0;y < yLength; y++) {
		for(var x = 0; x < xLength; x++) {
			newPiece.rep[x][y] = this.rep[yLength - y - 1][x];
		}
	}
	newPiece.fixObstructions(board);
	if(!newPiece.isObstructing(board) && !this.equals(newPiece)) {
		this.rep = newPiece.rep;
		this.fixObstructions(board);
		return true;
	}
	return false;
}

Piece.prototype.xLength = function()
{
	return this.rep.length;
}

Piece.prototype.yLength = function()
{
	return this.rep[0].length;
}

Piece.prototype.zoomBlit = function(xOffset, yOffset, zoomFactor)
{
	var factor = 10 * zoomFactor;
	for(var y=0;y<this.rep[0].length;y++) {
		for(var x=0;x<this.rep.length;x++) {
			if(this.rep[x][y] != NOBLOCK && this.y + y >= 0) {
				this.rep[x][y].zoomBlit(this.x*factor + x*factor + xOffset, this.y*factor + y*factor + yOffset, zoomFactor);
			}
		}
	}
}
Piece.prototype.blit = function(xOffset, yOffset) {
	for(var y=0;y<this.rep[0].length;y++) {
		for(var x=0;x<this.rep.length;x++) {
			if(this.rep[x][y] != NOBLOCK && this.y + y >= 0) {
				this.rep[x][y].blit(this.x * 10 + x * 10 + xOffset, this.y * 10 + y * 10 + yOffset);
			}
		}
	}
}

Piece.prototype.equals = function(other) {
	if(other.rep.length != this.rep.length || other.rep[0].length != this.rep[0].length)
		return false;
	
	for(var y = 0; y < this.rep[0].length; y++) {
		for(var x = 0; x < this.rep[0].length; x++) {
			if(this.rep[x][y] != other.rep[x][y])
				return false;
		}
	}
	return true;
}